#include "driver.h"
extern "C" {
 #include "fmopl.h"
}
#include "timer.h"

INT32 BurnTimerUpdateYM3812b(INT32 nCycles);
void BurnTimerEndFrameYM3812b(INT32 nCycles);
void BurnTimerUpdateEndYM3812b();
INT32 BurnTimerAttachSekYM3812b(INT32 nClockspeed);
INT32 BurnTimerAttachZetYM3812b(INT32 nClockspeed);
INT32 BurnTimerAttachZet2YM3812b(INT32 nClockspeed);

extern "C" void BurnYM3812bUpdateRequest();

INT32 BurnYM3812bInit(INT32 num, INT32 nClockFrequency, OPL_IRQHANDLER IRQCallback, INT32 (*StreamCallback)(INT32), INT32 bAddSignal);
void BurnYM3812bSetRoute(INT32 nChip, INT32 nIndex, double nVolume, INT32 nRouteDir);
void BurnYM3812bReset();
void BurnYM3812bExit();
extern void (*BurnYM3812bUpdate)(INT16* pSoundBuf, INT32 nSegmentEnd);
void BurnYM3812bScan(INT32 nAction, INT32* pnMin);

#define BURN_SND_YM3812b_ROUTE			0

#define BurnYM3812bRead(i, a) YM3812bRead(i, a)
#define BurnYM3812bWrite(i, a, n) YM3812bWrite(i, a, n)

